//------------------------------------------------------------------------------
// File: svr_taskinfoarray.cs
// This file is used for script methods relating to the task info tag array
// Author: Matthew Rudge
//------------------------------------------------------------------------------

//-Constants and Globals--------------------------------------------------------
// Array values for info pair tags (so they can be used in separate functions)
$TSI_TAGARRAY[0] = "";
$TSI_TAGARRAY[1] = "";
$TSI_TAGARRAY[2] = "";
$TSI_TAGARRAY[3] = "";
$TSI_TAGARRAY[4] = "";
$TSI_TAGARRAY[5] = "";
$TSI_TAGARRAY[6] = "";
$TSI_TAGARRAYCNT = 7;
//------------------------------------------------------------------------------

//-Functions--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Resets all values in the tag array
////////////////////////////////////////////////////////////////////////////////
function tsResetTagArray()
{
   $TSI_TAGARRAY[0] = "";
   $TSI_TAGARRAY[1] = "";
   $TSI_TAGARRAY[2] = "";
   $TSI_TAGARRAY[3] = "";
   $TSI_TAGARRAY[4] = "";
   $TSI_TAGARRAY[5] = "";
   $TSI_TAGARRAY[6] = "";
}

////////////////////////////////////////////////////////////////////////////////
//! Fills the values in the info tag array dependent upon the function type
//! \param %iFctnType Determines the info tag values to use
////////////////////////////////////////////////////////////////////////////////
function tsFillTagArrayValues(%iFctnType)
{
   // Reset array
   tsResetTagArray();
   
   // Get correct info pair tags per function type
   switch(%iFctnType)
   {
         //-Select--------------------------------------------------------------
      case $TSF_SELECT:
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 0);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 1);
         tsSetTagArrayIndex($TSI_TEAM, 2);
         
         //-Create--------------------------------------------------------------
      case $TSF_CREATE:
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 0);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 1);
         tsSetTagArrayIndex($TSI_TEAM, 2);
         
         //-Destroy-------------------------------------------------------------
      case $TSF_DESTROY:
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 0);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 1);
         tsSetTagArrayIndex($TSI_TEAM, 2);
         
         //-Zone----------------------------------------------------------------
      case $TSF_ZONE:
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 0);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 1);
         tsSetTagArrayIndex($TSI_ZONENAME, 2);
         tsSetTagArrayIndex($TSI_TEAM, 3);
         
         //-Employ--------------------------------------------------------------
      case $TSF_EMPLOY:
         tsSetTagArrayIndex($TSI_SLGCHARNAME, 0);
         tsSetTagArrayIndex($TSI_SLGCHARTYPE, 1);
         tsSetTagArrayIndex($TSI_SLGBLDGNAME, 2);
         tsSetTagArrayIndex($TSI_SLGBLDGTYPE, 3);
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 4);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 5);
         
         //-Quit----------------------------------------------------------------
      case $TSF_QUIT:
         tsSetTagArrayIndex($TSI_SLGCHARNAME, 0);
         tsSetTagArrayIndex($TSI_SLGCHARTYPE, 1);
         tsSetTagArrayIndex($TSI_SLGBLDGNAME, 2);
         tsSetTagArrayIndex($TSI_SLGBLDGTYPE, 3);
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 4);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 5);
         
         //-Pick Up-------------------------------------------------------------
      case $TSF_PICKUP:
         tsSetTagArrayIndex($TSI_SLGCHARNAME, 0);
         tsSetTagArrayIndex($TSI_SLGCHARTYPE, 1);
         tsSetTagArrayIndex($TSI_SLGPROPNAME, 2);
         tsSetTagArrayIndex($TSI_SLGPROPTYPE, 3);
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 4);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 5);
         
         //-Quick Job-----------------------------------------------------------
      case $TSF_QUICKJOB:
         tsSetTagArrayIndex($TSI_SLGCHARNAME, 0);
         tsSetTagArrayIndex($TSI_SLGCHARTYPE, 1);
         tsSetTagArrayIndex($TSI_SLGPROPNAME, 2);
         tsSetTagArrayIndex($TSI_SLGPROPTYPE, 3);
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 4);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 5);
         
         //-Repair--------------------------------------------------------------
      case $TSF_REPAIR:
         tsSetTagArrayIndex($TSI_SLGCHARNAME, 0);
         tsSetTagArrayIndex($TSI_SLGCHARTYPE, 1);
         tsSetTagArrayIndex($TSI_SLGBLDGNAME, 2);
         tsSetTagArrayIndex($TSI_SLGBLDGTYPE, 3);
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 4);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 5);
         
         //-Tool use------------------------------------------------------------
      case $TSF_TOOLUSE:
         tsSetTagArrayIndex($TSI_TOOLTYPE, 0);
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 1);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 2);
         tsSetTagArrayIndex($TSI_SLGCHARTYPE, 3);
         tsSetTagArrayIndex($TSI_SLGCHARNAME, 4);
         
         //-Tool purchase-------------------------------------------------------
      case $TSF_TOOLPURCHASE:
         tsSetTagArrayIndex($TSI_TOOLTYPE, 0);
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 1);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 2);
         
         //-Timer fire----------------------------------------------------------
      case $TSF_TIMERFIRE:
         tsSetTagArrayIndex($TSI_TIME, 0);
         
          //-Reform-------------------------------------------------------------
      case $TSF_REFORM:
         tsSetTagArrayIndex($TSI_SLGCHARNAME, 0);
         tsSetTagArrayIndex($TSI_SLGCHARTYPE, 1);
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 2);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 3);
         
         //-Task dialog done----------------------------------------------------
      case $TSF_DIALOGDONE:
         tsSetTagArrayIndex($TSI_DIALOGID, 0);
         tsSetTagArrayIndex($TSI_SLGCHARNAME, 1);
         tsSetTagArrayIndex($TSI_SLGCHARTYPE, 2);
         tsSetTagArrayIndex($TSI_SLGBLDGNAME, 3);
         tsSetTagArrayIndex($TSI_SLGBLDGTYPE, 4);
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 5);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 6);
         
         //-Experience Item-----------------------------------------------------
      case $TSF_XPBUY:
         tsSetTagArrayIndex($TSI_XPNAME, 0);
         
         //-Move----------------------------------------------------------------
      case $TSF_MOVE:
         tsSetTagArrayIndex($TSI_SLGMOVENAME, 0);
         tsSetTagArrayIndex($TSI_SLGMOVETYPE, 1);
         tsSetTagArrayIndex($TSI_SLGTARGETNAME, 2);
         tsSetTagArrayIndex($TSI_SLGTARGETTYPE, 3);
         
         //-Team Change---------------------------------------------------------
      case $TSF_TEAMCHANGE:
         tsSetTagArrayIndex($TSI_SLGOBJTYPE, 0);
         tsSetTagArrayIndex($TSI_SLGOBJNAME, 1);
         tsSetTagArrayIndex($TSI_OLDTEAM, 2);
         tsSetTagArrayIndex($TSI_NEWTEAM, 3);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Sets the tag array value at index specified
//! \param %val Value
//! \param %ind Index in tag array for value
////////////////////////////////////////////////////////////////////////////////
function tsSetTagArrayIndex(%val, %ind)
{
   $TSI_TAGARRAY[%ind] = %val;
}

////////////////////////////////////////////////////////////////////////////////
//! Returns the current info tag value stored in the info tag array
//! \param %ind Index in array of info tag value
//! \return Info tag integer value
////////////////////////////////////////////////////////////////////////////////
function tsGetTagArrayValue(%ind)
{
   return $TSI_TAGARRAY[%ind];
}

//------------------------------------------------------------------------------

// End svr_taskinfoarray.cs